/**
 * 
 */
package gov.va.med.mhv.integration.phr.service;

import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;

import java.util.Date;

/**
 * @author DNS
 *
 */
public abstract class AbstractProcessingPolicy implements ProcessingPolicy {

	protected boolean enabled = true;
	
	/* (non-Javadoc)
	 * @see gov.va.med.mhv.integration.phr.service.ProcessingPolicy#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean value) {
		this.enabled = value;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.integration.phr.service.ProcessingPolicy#isEnabled()
	 */
	@Override
	public boolean isEnabled() {
		return this.enabled;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.integration.phr.service.ProcessingPolicy#isAllowed(java.util.Date)
	 */
	@Override
	public abstract boolean isAllowed(Date lastProcessed);

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.integration.phr.service.ProcessingPolicy#isAllowed(gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus)
	 */
	@Override
	public abstract boolean isAllowed(FacilityExtractStatus es);

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.integration.phr.service.ProcessingPolicy#getProjectedDate(java.util.Date)
	 */
	@Override
	public abstract Date getProjectedDate(Date lastProcessed);

}
